#!/bin/sh

echo "Changing executable permissions.."
chmod 755 ./vsg60
chmod 755 ./bin/vsg60

echo "Configuring libraries.."
ldconfig -n ./lib

echo "Changing device permissions.."
sudo cp ./sh.rules /etc/udev/rules.d/

FILE=/etc/udev/rules.d/sh.rules
if test -f "$FILE"; then
    echo "\nInstallation successful\n\nRun VSG60 software in terminal with ./vsg60\nor in Files by double-clicking 'vsg60'\n"
else
    echo "\nUnable to change device permissions. Please copy sh.rules to /etc/udev/rules.d.\n"
fi

